/* checks the config file for errors and omissions
*
*/
//var Regex = require('regex');
var config = require('config');
var fs = require('fs');
//var net = require('net');
var http = require('http')
var express = require('express');
// Load the config options
global.appConfig = config.get('AppConfig');
global.providerConfig = config.get('ProviderConfig');
global.debugConfig = JSON.parse(JSON.stringify(config.get('DebugConfig')));

// Set up the logging function.  The last argument is for a stack to be 
// passed in.  This logger uses the stack and logs the line that called
// it.  So if you are writing a higher level logging function that calls 
// this one you can pass in your own stack and this logger will report the
// line number of the code that called your logging function.
//
// debugConfig.log(debugConfig.INFO, 'This is a Status message');
//
// debugConfig.log(debugConfig.INFO, 'This is a Status message passing a stack', new Error().stack);

global.debugConfig.log = function debug_log(type, str, stk) {
  if (type.show || this.ALL.show) {
      var now = new Date(Date.now()).toString().split(' ');
    var stack = stk ? stk : new Error().stack;
    var line = stack.split('\n')[2]
      .replace(global.dirname, '.')
      .replace(/^.*[.][/]/, '')
      .replace(/[:][^:]*[)]$/, '')
      .concat(' '.repeat(this.stackWidth))
      .substring(0, this.stackWidth);

    console.log('%s %s %s [ %s %s] %s', now[1], now[2], now[4], type.desc, line, str);

    if (type.trace)
      console.trace();
  }
};

exports.checkappconfig = function () {
  let passed_config = true;

  console.log('Checking config/default.json configuration file.');

  passed_config = passed_config && checkdebug();
  passed_config = passed_config && checkport();
  passed_config = passed_config && checkssl();
  passed_config = passed_config && checkprovider();

  if (!passed_config)
    exitserver();

  console.log('config/default.json looks good.  Starting server.');

  return;
};

function checkprovider() {
  let passed_config = true;

  passed_config = passed_config && validate('providerConfig', 'host', 'string', true);
  passed_config = passed_config && validate('providerConfig', 'port', 'string', true);
  passed_config = passed_config && validate('providerConfig', 'appxuser', 'string', false);
  passed_config = passed_config && validate('providerConfig', 'appxpass', 'string', false);
  passed_config = passed_config && validate('providerConfig', 'appxtoken', 'string', false);
  passed_config = passed_config && validate('providerConfig', 'enablessl', 'boolean', true);
  passed_config = passed_config && validate('providerConfig', 'sslRejectUnauth', 'boolean', true);
  passed_config = passed_config && validate('providerConfig', 'sslCheckSvrName', 'boolean', true);
  passed_config = passed_config && validate('providerConfig', 'sslCaFilePath', 'string', false);

  if (providerConfig.appxuser == '' || providerConfig.appxpass == '') {
    if (providerConfig.enablessl == false) {
      console.log('Error: When not running SSL you must specify providerConfig.appxuser and providerConfig.appxpass.');
      passed_config = false;
    }
    else if (providerConfig.appxtoken == '') {
      console.log('Error: When running SSL you must specify providerConfig.appxuser and providerConfig.appxpass or providerConfig.appxtoken.');
      passed_config = false;
    }
    else if (providerConfig.appxtoken.length != 60) {
      console.log('Error: When running SSL with a token, providerConfig.appxtoken must be set to a 60 character access token.');
      passed_config = false;
    }
  }

  return passed_config;
}

function checkdebug() {
  return validate('appConfig', 'debug', 'boolean', true);
};

function checkport() {
  return validate('appConfig', 'port', 'numeric', true);
};

function checkssl() {
  let flag = true;

  flag = flag && validate('appConfig', 'enablessl', 'boolean', true);
  flag = flag && validate('appConfig', 'systempath', 'http', false);

  if (appConfig.enablessl == true) {
	if (appConfig.sslPfxFile === "") {
		flag = flag && validate('appConfig', 'systemcert', 'file', true);
		flag = flag && validate('appConfig', 'certificatepath', 'file', true);
		flag = flag && validate('appConfig', 'privatekeypath', 'file', true);
	} else {
		flag = flag && validate('appConfig', 'systemcert', 'file', true);
		flag = flag && validate('appConfig', 'sslPfxFile', 'file', true);
		flag = flag && validate('appConfig', 'sslPfxPassphrase', 'string', true);
	} 
  }
  else {
    flag = flag && validate('appConfig', 'systemcert', 'file', false);
    flag = flag && validate('appConfig', 'certificatepath', 'file', false);
    flag = flag && validate('appConfig', 'privatekeypath', 'file', false);
  }

  return flag;
};

function exitserver() {
  console.log('Exiting the server now...');
  process.exit(1);
};

function validate(configStr, name, type, required) {
  let config = global[configStr];

  if (!config.has(name)) {
    console.log('Error: ' + configStr + ' must have an entry for ' + name + ' defined.');
    return false;
  }

  switch (type) {

    case 'string':
      if ((!isstring(config.get(name)) || (required && config.get(name) == ''))) {
        console.log('Error: ' + configStr + '.' + name + ' requires a string value be set.');
        return false;
      }
      break;

    case 'numeric':
      if (required && !isnumber(config.get(name))) {
        console.log('Error: ' + configStr + '.' + name + ' requires a numeric value be set.');
        return false;
      }
      break;

    case 'boolean':
      if (required && !isboolean(config.get(name))) {
        console.log('Error: ' + configStr + '.' + name + ' requires a boolean value be set.');
        return false;
      }
      break;

    case 'file':
      if ((!isstring(config.get(name))) || (required && config.get(name) == '')) {
        console.log('Error: ' + configStr + '.' + name + ' requires a file path value be set.');
        return false;
      }
      else if (config.get(name) != '' && !isfilereadable(config.get(name))) {
        console.log('Error: ' + configStr + '.' + name + ' must be a readable file path.');
        return false;
      }
      break;

    case 'http':
      if ((!isstring(config.get(name))) || (required && config.get(name) == '')) {
        console.log('Error: ' + configStr + '.' + name + ' requires an http:// url value be set.');
        return false;
      }
      else if (config.get(name) != '' && !ishttp(config.get(name))) {
        console.log('Error: ' + configStr + '.' + name + ' must be an http:// url.');
        return false;
      }
      break;

    case 'https':
      if ((!isstring(config.get(name))) || (required && config.get(name) == '')) {
        console.log('Error: ' + configStr + '.' + name + ' requires an https:// url value be set.');
        return false;
      }
      else if (config.get(name) != '' && !ishttp(config.get(name))) {
        console.log('Error: ' + configStr + '.' + name + ' must be an https:// url.');
        return false;
      }
      break;

    case 'url':
      if ((!isstring(config.get(name))) || (required && config.get(name) == '')) {
        console.log('Error: ' + configStr + '.' + name + ' requires an http:// or https:// url be set.');
        return false;
      }
      else if (config.get(name) != '' && (!ishttp(config.get(name))) && (!ishttps(config.get(name)))) {
        console.log('Error: ' + configStr + '.' + name + ' must be an http:// or https:// url.');
        return false;
      }
      break;

    default:
      console.log('checkconfigs.validate() unrecognized tyype=' + type);
      return false;
      break;
  }

  return true;
};

function isboolean(boolean) {
  return (typeof boolean == 'boolean');
};

function isnumber(number) {
  return (typeof number == 'number');
};

function isstring(string) {
  return (typeof string == 'string');
};

function ishttp(string) {
  var regex = new RegExp('(http:\/\/)[a-zA-Z0-9\.\/\-\_]*(:[0-9]+)*(\/[a-zA-Z0-9\.\/\-\_]*)*');
  return (regex.test(string) == true);
}

function ishttps(string) {
  var regex = new RegExp('(https:\/\/)[a-zA-Z0-9\.\/\-\_]*(:[0-9]+)*(\/[a-zA-Z0-9\.\/\-\_]*)*');
  return (regex.test(string) == true);
}

function isfiletype(filepath) {
  let flag = true;
  fs.stat(filepath, function fsStat(err, stats) {
    if (err) {
      console.log(err.code);
      flag = false;
    }
    return flag;
  });
};

function isfilereadable(filepath) {
  let flag = true;
  try {
    fs.accessSync(filepath, fs.R_OK);
  } catch (e) {
    flag = false;
  }
  return flag;
};

function isfilewriteable(filepath) {
  let flag = true;
  try {
    fs.accessSync(filepath, fs.W_OK);
  } catch (e) {
    console.log(e.code);
    flag = false;
  }
  return flag;
};
