var dataServicesServiceCtlVersionStr = "1.0.0.24082713";
var dataServicesServiceCtlVersionNum = 10000.24082713;

//Parse the command line arguments
var args = require('minimist')(process.argv.slice(2));
var fs = require('fs');

// Create the arguments we'll be using
var command, port, name, appx_host, appx_port, appx_user, appx_pass;
var createconfigfile = true;
var allReqInstalled = true;

// Parse the command
if (args._.length == 1) {
    command = args._[0];
} else {
    err_message("Invalid number of commands used.");
    return;
}

// Check for a configuration file
if (command === "install" && args.configfilename) {
	var filename = process.cwd() + "/" + args.configfilename;
	if (fs.existsSync(filename)) { 
		try {
			var contents = JSON.parse(fs.readFileSync(filename, "utf8"));
			if (contents != null && contents.AppConfig != null && contents.AppConfig.port != null ) {
				var extension = parseInt(process.versions.node.split('.')[0], 10) >= 19 ? '.json5' : '.json';
				port = contents.AppConfig.port; 
			    name = "APPX-Data-Services-" + port;
				
				// Copy the specified file to the 'config' folder 
				var configFileName = 'config/default-' + port + extension; 
				fs.copyFileSync(filename, configFileName);
				
				createconfigfile = false;
				install_service();
				return; 
			}
	        console.log('ERROR: The specfied file %s is not a APPX Data Services configuration file.', args.configfilename);
			return; 
		} catch (err) {
	        console.log('ERROR: The specfied file %s is not a JSON formatted file.', args.configfilename);
			return; 
		}
	} else 	{ 
		err_message("The configuration file doesn't exist.");
		return; 
	}
}

// Get the service port
if (args.port && args.p) {
    err_message("Service port was defined multiple times.");
    return;
} else if (args.p) {
    port = args.p;
} else if (args.port) {
    port = args.port;
} else {
    err_message("Please define a service port.");
    return;
}

// Get the service name
if (args.name && args.n) {
    err_message("Service name was defined multiple times.");
    return;
} else if (args.n) {
    name = args.n;
} else if (args.name) {
    name = args.name;
} else {
    name = "APPX-Data-Services-" + port;
}

// Get the APPX host/port if it was given
if (args.appxhost) {
    appx_host = args.appxhost;
}
if (args.appxport) {
    appx_port = args.appxport;
}

// Get the APPX user/pass if it was given
if (args.appxuser) {
    appx_user = args.appxuser;
}
if (args.appxpass) {
    appx_pass = args.appxpass;
}

// Switch based on the command
switch(command) {

    case "install":
        install_service();
        break;

    case "remove":
        remove_service();
        break;

    case "help":
        err_message();
        return;

    default:
        err_message("Invalid command.");
        return;


} // End switch

// -----------------------------------------------------------------------------
// EVERYTHING BELOW THIS IS A FUNCTION DEFINITION
// -----------------------------------------------------------------------------

// Install the API service
function install_service() {
    console.log("Installing as: " + name);

    // Make sure the required modules are installed.
    var modules = [
        'body-parser',
        'config',
        'crypto',
        'express',
        'handlebars',
        'html5-to-pdf',
        'minimist',
        'net',
        'pdf-merge',
        'request',
        'string_decoder',
        'uuid'
    ];
	
	// For windows, the 'node-windows' package we need to update that package with our custom changes
	//	of a newer version of the 'winsw.exe' binary and the script files 'daemon.js' and 'winsw.js'
	if (process.platform == 'win32') {
		var isVer19 = parseInt(process.versions.node.split('.')[0], 10) >= 19 ? true : false;
		fs.copyFile('winsw-2.3.0-bin.exe', './node_modules/node-windows/bin/winsw/winsw.exe', (err) => {
			if (err) throw err;
			console.log('winsw.exe was updated for node-windows\n');
		});	
		fs.copyFile('winsw.js', './node_modules/node-windows/lib/winsw.js', (err) => {
			if (err) throw err;
			console.log('winsw.js was updated for node-windows');
		});
		fs.copyFile('daemon.js', './node_modules/node-windows/lib/daemon.js', (err) => {
			if (err) throw err;
			console.log('daemon.js was updated for node-windows');
		});
		
		// When installing under nodeJS version >= 19.x and because of the JSON parser issue documented here: https://github.com/node-config/node-config/issues/715
		// We'll implement the work around until there is a better fix
		if (isVer19) {
			if (fs.existsSync('./config/default.json')) {
				fs.rename('./config/default.json', './config/default.json5', (err) => {
					if (err) throw err;
					console.log('default.json was renamed default.json5 for nodeJS 19.x');
				});
			}
		} 
	}
	
    // For linux, we need to copy the custom service files templates into place
    if (process.platform == "linux") {
		fs.copyFile('systemd/service', 'node_modules/node-linux/lib/templates/systemd/service', (err) => {
			if (err) throw err;
			console.log('service was updated for node-linux');
		});	
		fs.copyFile('systemd/service-wrapper', 'node_modules/node-linux/lib/templates/systemd/service-wrapper', (err) => {
			if (err) throw err;
			console.log('service-wrapper was updated for node-linux');
		});
		fs.copyFile('systemd/daemon.js', 'node_modules/node-linux/lib/daemon.js', (err) => {
			if (err) throw err;
			console.log('daemon.js was updated for node-linux');
		});
		fs.copyFile('systemd/systemd.js', 'node_modules/node-linux/lib/systemd.js', (err) => {
			if (err) throw err;
			console.log('systemd.js was updated for node-linux');
		});
		fs.copyFile('systemd/systemv.js', 'node_modules/node-linux/lib/systemv.js', (err) => {
			if (err) throw err;
			console.log('systemv.js was updated for node-linux');
		});
    }
    
    // If no configuration file was specified 
    if (createconfigfile) {
        // Write the port to the config file
        var conf = {
            AppConfig: {
                port: port,
    			debug: false,
    			systempath: "",
    			systemcert: "",
    			certificatepath: "",
    			privatekeypath: "",
    			enablessl: false
            },
            ProviderConfig: {
    			appxtoken: "",
    			enablessl: false,
    			sslRejectUnauth: false,
    			sslCheckSvrName: false,
    			sslCaFilePath: ""
    		},
    		DebugConfig: {
    			stackWidth: 22,
    			STAT: { desc: "STATUS ", trace: false, show: true  },
    			ERROR: { desc: "ERROR  ", trace: true,  show: true  },
    			WARN: { desc: "WARNING", trace: false, show: false },
    			INFO: { desc: "INFO   ", trace: false, show: false },
    			DATA: { desc: "DATA   ", trace: false, show: false },
    			DUMP: { desc: "DUMP   ", trace: false, show: false },
    			ALL: { desc: "       ", trace: false, show: false }
    		}
        };

        if (appx_host) {
            conf.ProviderConfig.host = appx_host;
        }
        if (appx_port) {
    		// Port # must be string here 
            conf.ProviderConfig.port = appx_port.toString();
        }

        if (appx_user) {
            conf.ProviderConfig.appxuser = appx_user;
        }
        if (appx_pass) {
            conf.ProviderConfig.appxpass = appx_pass;
        }
    	
		// Save the new configuration file
		//
		// When installing under nodeJS version >= 19.x and because of the JSON parser issue documented here: https://github.com/node-config/node-config/issues/715
		// We'll implement the work around until there is a better fix
		var extension = parseInt(process.versions.node.split('.')[0], 10) >= 19 ? '.json5' : '.json';
    	var configFileName = 'config/default-' + port + extension; 
        fs.writeFile(configFileName, JSON.stringify(conf, null, 4), (err) => {if (err) throw err; console.log("\nConfiguration saved to " + configFileName); });
    }
	
	// Include the correct service wrapper module in the module installation check  
	// Require the correct service wrapper for the platform to be installed 
	var Service;
	if (process.platform === 'win32') {
		modules.push("node-windows");
		Service = require('node-windows').Service;
	} else if (process.platform === 'linux') {
		modules.push("node-linux");
		Service = require('node-linux').Service;
	} else {
        err_message("Unsupported Platform");
        return;
	}
	
    console.log("\nChecking for required modules...");
    moduleTest(modules);
    
    // Create new service object
    var svc = new Service({
        name: name,
        description: 'APPX Data Services that allows apps to talk to an APPX server.',
        user: 'root',
        group: 'root',
        script: process.cwd() + '/index.js',

        // Set variable so appx-stream-api.js knows where to push files to.
        env: [
            {
                name: "APPX_STREAM_API_DIR",
                value: require('path').resolve(__dirname)
            }, {
                name: "NODE_CONFIG_DIR",
                value: process.cwd() + '/config'
            }, {
                name: "NODE_APP_INSTANCE",
                value: port
            }
        ]
    });

    // Installs service
    svc.on('alreadyinstalled', function(){
        console.log("Already installed, restarting " + name + " service...\n");
        svc.stop();
        svc.start();
        console.log("Done");
    });

    svc.on('install', function(){
        console.log("Installing " + name + " service...");
        setTimeout(function(){
        svc.start();
        },5000);
        
        console.log("Done");
    });

    svc.on('start', function(){
        console.log("Service " + name + " started...");
        // Run 'systemctl enable' so the service will autostart 
        var exec = require('child_process').exec;
        var cmd = 'systemctl enable ' + name.replace(/[^a-zA-Z0-9\_]+/gi,'').toLowerCase();
        console.log('Running %s...', cmd);
        exec(cmd,function(err){ if (!err) {console.log("Done");} });
    });

    svc.install();

    return;
}

// Remove the API service
function remove_service() {
    console.log("Removing: " + name);

	// Require the correct service wrapper for the platform to be uninstalled 
	var Service;
	if (process.platform === 'win32') {
		Service = require('node-windows').Service;
	} else if (process.platform === 'linux') {
		Service = require('node-linux').Service;
	} else {
        err_message("Unsupported Platform");
        return;
	}

    //Create new service object
    var svc = new Service({
        name: name,
        description: 'API that allows apps to talk to an APPX server.',
        script: process.cwd() + '/index.js',

        // Set variable so appx-stream-api.js knows where to push files to.
        env: [
            {
                name: "APPX_STREAM_API_DIR",
                value: require('path').resolve(__dirname)
            }, {
                name: "NODE_CONFIG_DIR",
                value: process.cwd() + '/config'
            }, {
                name: "NODE_APP_INSTANCE",
                value: port
            }
        ]
    });

    //Listen for Uninstall event.
    svc.on('uninstall', function(){
        console.log('Uninstall complete.');
        console.log('The service exists: ', svc.exists);
        
        if (svc.exists) {
            // Run 'systemctl disable' so the service autostart link is removed 
            var exec = require('child_process').exec;
            var cmd = 'systemctl disable ' + name.replace(/[^a-zA-Z0-9\_]+/gi,'').toLowerCase();
            console.log('Running %s...', cmd);
            exec(cmd,function(err){ if (!err) {console.log("Done");} });
            cmd = 'systemctl daemon-reload';
            console.log('Running %s...', cmd);
            exec(cmd,function(err){ if (!err) {console.log("Done");} });
        }
        // Save a copy then remove the instance configuration file
		//
		// When uninstalling under nodeJS version >= 19.x and because of the JSON parser issue documented here: https://github.com/node-config/node-config/issues/715
		// We'll implement the work around until there is a better fix
		var isVer19 = parseInt(process.versions.node.split('.')[0], 10) >= 19 ? true : false;
		var extension = !isVer19 ? '.json' : '.json5';
		if (fs.existsSync('config/default-' + port + extension)) {
			fs.copyFileSync('config/default-' + port + extension, 'default-' + port + '.json.bak');
			fs.unlinkSync('config/default-' + port + extension);
		}
		if (isVer19) {
			if (fs.existsSync('./config/default.json5')) {
				fs.renameSync('./config/default.json5', './config/default.json');
			}
		}		
    });

    //Runs uninstall
    svc.uninstall();

    return;
}

// Print Help Text
function err_message(msg_in) {
    var msg = "\nUsage: node servicectl.js <command> [args]\n\n" +
        "Where <command> is one of:\n" +
        "   install, remove, help\n\n" +
        "Arguments:\n\n" +
        "   -p, --port\n" +
        "       The port you want to the API to listen on.\n\n" +
        "   -n, --name\n" +
        "       The name you want the service to be created with.\n\n" +
        "Install-Only Arguments:\n\n" +
        "   --appxhost\n" +
        "       The host address of your APPX server.\n\n" +
        "   --appxport\n" +
        "       The login manager port of your APPX server.\n\n" +
        "   --appxuser\n" +
        "       The APPX user the API will log in as.\n\n" +
        "   --appxpass\n" +
        "       The password for the APPX user.\n\n" +
        "   --configfilename\n" +
        "       The name of a configuration file to use for installation.\n\n" +
        "Examples:\n\n" +
        "   node servicectl.js install -p 3000 --appxhost=192.168.1.5 --appxport=8060 --appxuser=webuser --appxpass=mypassword\n\n" +
        "   node servicectl.js remove --port=3000\n\n" +
        "   node servicectl.js help\n";

        if (msg_in) {
            console.log(msg_in);
        }
        console.log(msg);
}

// Test for all modules in array
function moduleTest(modules){
    modules.forEach(function(name){
	if ( !testForModule(name) )
	    allReqInstalled = false;
    });

    console.log("");

    if( !allReqInstalled ) {
        console.log("Missing modules.  Please install required modules and run again.");
        process.exit();
    }
}

// Test to see if an individual module is installed
function testForModule(name) {
    var nameStr = name + "                              ";
    process.stdout.write("Module: " + nameStr.substring(0,25) + " - ");
    if( isModuleInstalled(name) ) {
        console.log("Installed.");
        return true;
    } else {
        console.log("Missing.\n    Run 'yarn add " + name + "' to install.");
        return false;
    }
}

// Test is the given module is installed
function isModuleInstalled(name) {
    try {
        require.resolve(name);
        return true;
    } catch(ex) {
	    return false;
    }
}
