/*
 * The crypto functions we'll use for things like password hashing
 */

var crypto = require('crypto');

// Generate a buffer containing a random 32 byte salt
exports.createsalt = function() {
    var salt = Buffer.from(crypto.randomBytes(32)).toString('base64');
    return salt;
};

// Hash the salt and the string together
exports.createhash = function(tohash, salt) {
    var hashBuffer = crypto.pbkdf2Sync(tohash, salt, 16000, 32, 'SHA1');
    var hash = Buffer.from(hashBuffer).toString('base64');
    return hash;
};
