// routes/api/index.js
var router = require('express').Router();

/*
 * Load handlers for routes that require something special, like password
 * hashing.
 */
//router.use('/apptoken', require('./apptoken'));
//router.use('/accts', require('./accts'));
//router.use('/system', require('./system'));
//router.use('/forms', require('./forms'));
//router.use('/documents', require('./documents'));

/*
 * Default handler for requests with only a command.
 */
router.all('/:command', function(req, res) {

    var message = {
        cmd: req.params.command,
        filters: req.query,
        commandtype: req.method,
        headers: req.headers,
        data: req.body
    };

    appx.send(message, function(result) {
        if (result) {
            res.json(result);
        } else {
            res.status(500);
//            res.send(result);
        }
    });

});

/*
 * Default handler for requests with a command and ID
 */
router.all('/:command/:id', function(req, res) {

    var message = {
        cmd: req.params.command,
        id: req.params.id,
        filters: req.query,
        commandtype: req.method,
        headers: req.headers,
        data: req.body
    };

    appx.send(message, function(result) {
        if (result) {
            res.json(result);
        } else {
            res.status(500);
            res.send(result);
        }
    });

});

/*
 * Default handler for requests with a command, ID, and action
 */
router.all('/:command/:id/:action', function(req, res) {

    var message = {
        cmd: req.params.command,
        id: req.params.id,
        action: req.params.action,
        filters: req.query,
        commandtype: req.method,
        headers: req.headers,
        data: req.body
    };

    appx.send(message, function(result) {
        if (result) {
            res.json(result);
        } else {
            res.status(500);
            res.send(result);
        }
    });

});

module.exports = router;
