// routes/index.js
var router = require('express').Router();
var PDFMerge = require('pdf-merge');

//Route /dstest to check the API status
router.get('/dstest', function(req, res) {
    res.send('OK');
});

// Route /dsver to return the version number string for data services
router.get('/dsver', function(req, res) {
    res.send("[{\"Data Services Version\":\"" + global.dataServicesVersionStr + "\"}]");
});

// Route /dsdate to check the web side connection
router.get('/dsdate', function(req, res) {
	var date_ob = new Date();
	var date = IntTwoChars(date_ob.getDate());
	var month = IntTwoChars(date_ob.getMonth() + 1);
	var year = date_ob.getFullYear();
	var hours = IntTwoChars(date_ob.getHours());
	var minutes = IntTwoChars(date_ob.getMinutes());
	var seconds = IntTwoChars(date_ob.getSeconds());
	var localdate = ` ${month}/${date}/${year} ${hours}:${minutes}:${seconds}`;	
	
	date = IntTwoChars(date_ob.getUTCDate());
	month = IntTwoChars(date_ob.getUTCMonth() + 1);
	year = date_ob.getUTCFullYear();
	hours = IntTwoChars(date_ob.getUTCHours());
	minutes = IntTwoChars(date_ob.getUTCMinutes());
	seconds = IntTwoChars(date_ob.getUTCSeconds());
	var utcdate = ` ${month}/${date}/${year} ${hours}:${minutes}:${seconds}`;	
	
    res.send("[{\"LocalDateTime\":\"" + localdate + "\"},{\"UtcDateTime\":\"" + utcdate + "\"} ]");
});

function IntTwoChars(i) {
	return (`0${i}`).slice(-2);
}

// Route to merge several PDFs together
router.post('/mergepdf', function(req, res) {

    var pdfMerge = new PDFMerge(req.body.files, appConfig.pdftkpath);
    pdfMerge.asNewFile(req.body.outfile).merge(function(error, filepath) {
        if (error) {
            console.log(error);
            res.status(500);
            res.send();
            return;
        }
        res.send();
    });

});

// Import the /api routes
router.use('/api', require('./api'));

module.exports = router;