var localConnectorVersionStr = "6.2.0.26012901";
var localConnectorVersionNum = 62000.26012901;

var persistStorage = {};
getPersistStorage();

localStorage.setItem("showInfoPopup", "true");

global.dnd = null; //global is shared between windows
global.filedialog = null;
global.lang = 'en';
global.appName = null;
global.authDialogState = "none";

global.logfile = "log.txt";
global.logwrite = false;

nw.Window.get().hide();

var WebSocketServer = require('ws').Server;
var fs = require('fs');
var path = require('path');
var got = require('got');

var wss = new WebSocketServer({
    host: "localhost",
    port: 3013
});

const second = 1000;
const fileCountTrigger = 1000;
const timeFactor = .0017;  // The approximate amount of time, in fractions of a seconds, for one dropped file to be processed

logit("AppxLocalConnector started. Logging is " + (global.logwrite ? "enablled by default.":"disabled by default."), true);

// Mapping of functions that can be called and if they are consider secure or not.  Secure
// functions must be authorised with a valid security token.

var functions = {
    "localosinit":      { secure: false, function: cmdLocalOsInitFn      },
    "auth":             { secure: false, function: cmdAuthFn             },
    "dnd":              { secure: true,  function: cmdDndFn              },
    "file-dialog-nw":   { secure: true,  function: cmdFileDialogNwFn     },
    "openfile":         { secure: true,  function: cmdOpenFileFn         },
    "openimage":        { secure: true,  function: cmdOpenImageFn        },
    "runoscmd":         { secure: true,  function: cmdRunOsCmdFn         },
    "execoscmd":        { secure: true,  function: cmdExecOsCmdFn        },
    "setclipboard":     { secure: true,  function: cmdSetClipboardFn     },
    "getclipboard":     { secure: true,  function: cmdGetClipboardFn     },
    "createfile":       { secure: true,  function: cmdCreateFileFn       },
    "appendfile":       { secure: true,  function: cmdAppendFileFn       },
    "localoscreatedir": { secure: true,  function: cmdLocalOsCreateDirFn },
    "update":           { secure: true,  function: cmdUpdateFn           },
	"getCertificate":   { secure: true,  function: cmdGetCertificateFn   },
};

wss.on('connection', function (ws) {

    console.log("user connected:  ");

    let appx_session = {
        authToken: undefined,
		ca: undefined
    };

    ws.on('message', function (message) {
        var ms;
        var goodMessage;

        // See if we can decode the message transaction

        try {
            ms = JSON.parse(message);
            goodMessage = true;
        } catch (appxerror) {
            console.log(appxerror);
            goodMessage = false;
        }

        // Try to run the requested command function

        try {
            if (goodMessage) {
                let cmd = functions[ms.cmd];
                if( cmd ) {
                    cmd.function(ms, ws, appx_session, isAuthorized(ms));
                } else {
                    console.log('no message');
                }
            }
        } catch (appxerror2) {
            console.log(appxerror2);
            if (JSON.stringify(appxerror2).indexOf("mkdir") !== -1) {
                ms.data = appxerror2;
                ms.hasdata = "yes";
                ms.haserror = "yes";
                ms.error = err;
                ms.type = "LOCALOS-CREATEFILE";
                ws.send(JSON.stringify(ms));
            }
        }

    });

    ws.send(JSON.stringify('connection accepted on localhost:3013'));
});

function logit( msg, alwaysLog = false ) {
    if( global.logwrite || alwaysLog) {
	let curr = new Date().toLocaleString();
	let txt = "[" + curr + "] " + msg + "\n";
	fs.appendFileSync(global.logfile, txt);
    }
}

/**
 * cmdUpdateFn - implementation of the 'update' command.
 * 
 * This command will update the AppxLocalConnector files to a newer version.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdUpdateFn(ms, ws, appx_session, isAuthorized) {

    var currfile = ms.args[0];
    var b = new Buffer.from(currfile.filedata);

    try {
        fs.unlinkSync(currfile.filename.trim(), function (err) {});
    } catch (e) {}

    fs.writeFileSync(currfile.filename.trim(), b);


    var DecompressZip = require('decompress-zip');
    var unzipper = new DecompressZip(currfile.filename.trim())

    unzipper.on('error', function (err) {
        console.log('Caught an error = ' + err);
    });

    unzipper.on('extract', function (log) {

        var ms = {
            data: [],
            hasdata: "no",
            haserrors: "no",
            type: "LOCALOS-RELOAD"
        };
        ws.send(JSON.stringify(ms));

        console.log("updating local connector: " + currfile.filename.trim());
        wss.close();
        document.location.reload(true);
    });


    unzipper.extract({
        filter: function (file) {
            return file.type !== "SymbolicLink";
        }
    });
}

/**
 * cmdLocalOsCreateDirFn - implementation of the 'localoscreatedir' command.
 * 
 * This command will attempt to create a local directory path.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdLocalOsCreateDirFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);
        return;
    }

    var arrayDir = ["Data", "Drop", "Print", "Resource", "Token"];

	logit("Command: Local Os Create Dir Create @ Base directory -> " + ms.args[0] );
    
	var exists; 
	for (var i = 0; i < arrayDir.length; i++) {
		exists = fs.existsSync(ms.args[0] + arrayDir[i] );
		logit("Sub-directory: " + "\"" + arrayDir[i] + "\"" + (exists ? " (already exists)" : " (will be created)") );
		fs.mkdir(ms.args[0] + arrayDir[i],{recursive: true}, function(err){});
    }
}

/**
 * cmdAppendFileFn - implementation of the 'appendfile' command.
 * 
 * This command will append data to a local disk file.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdAppendFileFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);

        ms.data = "Authorization Failure";
        ms.hasdata = "yes";
        ms.haserror = "yes";
        ms.error = "Authorization Failure";
        ms.type = "LOCALOS-APPENDFILE";
        ws.send(JSON.stringify(ms));

        return;
    }

    var timer = 0;
    var currfile = ms.args[0];
	var parse = path.parse(currfile.filename.trim());	
    var b = new Buffer.from(currfile.filedata, "base64");

    try {
		
//		logit("Command: Append File -> Appeding " + currfile.filedata.length + " bytes to file \"" + parse.base + "\"");
		
        fs.appendFileSync(currfile.filename.trim(), b);
        ms.data = {
            "file": currfile.filename.trim(),
            "appended": true,
            "length": currfile.filedata.length
        };
        ms.hasdata = "yes";
        ms.haserrors = "no";
        ms.type = "LOCALOS-APPENDFILE";
        ws.send(JSON.stringify(ms));
    } catch (ex) {
        ms.data = ex;
        ms.hasdata = "yes";
        ms.haserror = "yes";
        ms.error = ex;
        ms.type = "LOCALOS-APPENDFILE";
        ws.send(JSON.stringify(ms));
    }
}

/**
 * cmdCreateFileFn - implementation of the 'createfile' command.
 * 
 * This command will create a local disk file.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdCreateFileFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);

        ms.data = "Authorization Failure";
        ms.hasdata = "yes";
        ms.haserror = "yes";
        ms.error = "Authorization Failure";
        ms.type = "LOCALOS-CREATEFILE";
        ws.send(JSON.stringify(ms));

        return;
    }

    var currfile = ms.args[0];
	var parse = path.parse(currfile.filename.trim());	
	
    if (parse.dir) {
		var exists = fs.existsSync( parse.dir + path.sep + parse.base);
		
		logit("Command: Create File -> File \"" + parse.base + (exists ? "\" already exists and will be truncated @ ":"\" will be created @ ") + parse.dir);
		
		if (!exists) {
			fs.mkdirSync(parse.dir, {recursive:true});
		}
    }
    //open the file using "w" flag creates the file and if it exists truncates it to 0 bytes
	fs.open((parse.dir + path.sep + parse.base), "w", function (err, fd) {
		if (!err) {
			logit("Command: Create File -> File \"" + parse.base + (exists ? "\" was truncated":"\" was created"));
			// close the file first
			fs.close(fd);
			ms.data = {
				"file": (parse.dir + path.sep + parse.base),
				"saved": true
			};
			ms.hasdata = "yes";
			ms.haserrors = "no";
			ms.type = "LOCALOS-CREATEFILE";
			ws.send(JSON.stringify(ms));
		} else {
			ms.data = err;
			ms.hasdata = "yes";
			ms.haserror = "yes";
			ms.error = err;
			ms.type = "LOCALOS-CREATEFILE";
			ws.send(JSON.stringify(ms));
		}
	});
}

/**
 * cmdGetClipboardFn - implementation of the 'getclipboard' command.
 * 
 * This command will get the contents of the clipboard.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdGetClipboardFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);

        ms.haserrors = "yes";
        ms.data = "Authorization Failure";
        ms.type = "LOCALOS-ERROR";
        ws.send(JSON.stringify(ms));

        return;
    }

    try {
		logit("Command: Get Clipboard (started)");
        var cb = require('copy-paste');
        cb.paste(function (a, b) {
			logit("Command: Get Clipboard error: " + (a === null ? "None":a));
			logit("Command: Get Clipboard data: " + b);
			
            ms.haserrors = "no";
            ms.hasdata = "yes";
			ms.data = {
				datatype: 1,
				data: b,
				datalength: b.length,
				senddata: 1
			};
            ms.type = "LOCALOS-GETCLIPBOARD";
            ws.send(JSON.stringify(ms));
        });
    } catch (e) {
        console.log('get clipboard error: ' + e);
        ms.haserrors = "yes";
        ms.data = e;
        ms.type = "LOCALOS-ERROR";
        ws.send(JSON.stringify(ms));
    }
}

/**
 * cmdSetClipboardFn - implementation of the 'setclipboard' command.
 * 
 * This command will set the contents of the clipboard.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdSetClipboardFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);

        ms.haserrors = "yes";
        ms.data = "Authorization Failure";
        ms.type = "LOCALOS-ERROR";

        return;
    }

    try {
        var cb = require('copy-paste');

        cb.copy(ms.args[0]);

        ms.haserrors = "no";
        ms.hasdata = "yes";
        ms.data = "CLIPBOARD WAS SET TO:  " + ms.args[0];
        ms.type = "LOCALOS-SETCLIPBOARD";
    } catch (e) {
        console.log('set clipboard error: ' + e);
        ms.haserrors = "yes";
        ms.data = e;
        ms.type = "LOCALOS-ERROR";
    }

    ws.send(JSON.stringify(ms));
}

/**
 * cmdExecOsCmdFn - implementation of the 'execoscmd' command.
 * 
 * This command will execute an OS command.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdExecOsCmdFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);

        ms.haserrors = "yes";
        ms.error = "Authorization Failure";
        ms.hasdata = "yes";
        ms.data = "Authorization Failure";
        ms.type = "LOCALOS-EXECOMMAND";

        return;
    }

    var exec = require('child_process');
    var child;

    child = exec.execSync(ms.args[0]);
    ms.hasdata = "yes";
    ms.data = child;
    ms.type = "LOCALOS-EXECOMMAND";

    ws.send(JSON.stringify(ms));
}

/**
 * cmdRunOsCmdFn - implementation of the 'runoscmd' command.
 * 
 * This command will run an OS command and capture the resulting stdout and codes.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdRunOsCmdFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);

        ms.data = "Authorization Failure";
        ms.haserrors = "yes";
        ms.hasdata = "yes";
        ms.error = "Authorization Failure";
        ms.type = "LOCALOS-ERROR";
        ws.send(JSON.stringify(ms));

        return;
    }

    try {
        var spawn = require('child_process').spawn,
            ls = spawn(ms.args[0], ms.args.splice(1, ms.args.length));

        ls.stdout.on('data', function (data) {
            ms.data = data;
            ms.haserrors = "no";
            ms.hasdata = "yes";
            ms.type = "LOCALOS-RUNCOMMAND";
            ws.send(JSON.stringify(ms));
        });

        ls.stderr.on('data', function (data) {
            ms.data = data;
            ms.haserrors = "yes";
            ms.hasdata = "yes";
            ms.type = "LOCALOS-ERROR";
            ws.send(JSON.stringify(ms));
        });

        ls.on('close', function (code) {
            ms.data = code;
            ms.haserrors = "no";
            ms.hasdata = "yes";
            ms.type = "LOCALOS-ERROR";
            ws.send(JSON.stringify(ms));
        });

        ls.on('exit', function (code) {
            ms.data = code;
            ms.haserrors = "no";
            ms.hasdata = "yes";
            ms.type = "LOCALOS-RUNCOMMAND";
            ws.send(JSON.stringify(ms));
        });

        ls.on('error', function (data) {
            ms.data = data;
            ms.haserrors = "no";
            ms.hasdata = "yes";
            ms.type = "LOCALOS-RUNCOMMAND";
            ws.send(JSON.stringify(ms));
        });

    } catch (e) {
        console.log("error in runoscmd:  " + e);
    }

}

/**
 * cmdOenImageFn - implementation of the 'openimage' command.
 * 
 * This command will open a disk file and return the contents.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdOpenImageFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);

        ms.hasdata = "no";
        ms.haserror = "yes";
        ms.error = "Authorization Failure";
        ms.type = "LOCALOS-ERROR";
        ws.send(JSON.stringify(ms));

        return;
    }

    fs.readFile(ms.args[0], function (err, data) {

        if (!err) {
            ms.data = data;
            ms.hasdata = "yes";
            ms.haserrors = "no";
            ms.type = "LOCALOS-OPENIMAGE";

            ws.send(JSON.stringify(ms));
        } else {
            ms.hasdata = "no";
            ms.haserror = "yes";
            ms.error = err;
            ms.type = "LOCALOS-ERROR";
            ws.send(JSON.stringify(ms));
            console.log(err);
        }

    });
}

/**
 * cmdOenFileFn - implementation of the 'openfile' command.
 * 
 * This command will open a disk file and push it's contents into mongo.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdOpenFileFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);

        ms.hasdata = "no";
        ms.haserror = "yes";
        ms.error = "Authorization Failure";
        ms.type = "LOCALOS-ERROR";
        ws.send(JSON.stringify(ms));

        return;
    }

    logit("Command: Open File (started)");

    try {
        var mFileName = ms.args[0];
        logit("openfile: arg0 = " + mFileName );
		
		if (!fs.existsSync(mFileName)) {
			console.log("*** Client File Not Found");
			console.dir(ms);

			logit("openfile: Client File Not Found = " + mFileName );

			ms.hasdata = "no";
			ms.haserror = "yes";
			ms.error = "File Not Found";
			ms.type = "LOCALOS-ERROR";
			ws.send(JSON.stringify(ms));

			return;
	 	}
		
        var mongoFileName = mFileName.replace(/ /g, "_").replace(/\//g, "__");
        logit("openfile: MongoFilename = " + mongoFileName);
        var url = ms.protocol + "://" + ms.mongoHost + ":" + ms.port + ms.httpPath + "/upload/" + ms.uid + "_" + ms.pid + "/" + encodeURIComponent(mongoFileName);
        logit("openfile: url = " + url);
        var rs = fs.createReadStream(mFileName);
        var options = {};
        if(appx_session.ca){
            options.https = {
                                certificateAuthority: appx_session.ca
                            };
        }

		// get the start date
		var startdate = new Date();
		var showProgressMessages = ms.showProgressMessages;
        var pipeline = require('stream').pipeline;
		const strm = got.stream.post(url, options);
		const stats = fs.statSync(mFileName);
		
		if (showProgressMessages == "both" || showProgressMessages == "mongo") {
			// callback for sending the upload to Mongo progress messages
			strm.on('uploadProgress', progress => {
//				logit("Progress: percent = " + progress.percent + ", transferrd = " + progress.transferred + ", total = " + stats.size);
				var args = {
					showProgressMessages: showProgressMessages,
					transfersize: progress.transferred,
					filesize: stats.size
				};			
				var ms = {
					cmd: 'localMessageToClient',
					args: args,
					handler: "appxreceivefilehandler",
					type: "LOCALOS-OPENFILE",
					fileName: mFileName,
					mongoFileName: mongoFileName,
					data: null
				};
				ws.send(JSON.stringify(ms));
			});		
		}
		
        pipeline(rs, strm, function pl_callback(error){
            if(error){
                logit("openfile: **ERROR** = " + err);
                var ms = {};
                ms.cmd = "openfile";
                ms.hasdata = "no";
                ms.haserror = "yes";
                ms.error = err;
                ms.type = "LOCALOS-ERROR";
                ws.send(JSON.stringify(ms));
                console.log(err);
            }
            else{
				const stats = fs.statSync(mFileName);
				var args = {
					showProgressMessages: showProgressMessages,
					filesize: stats.size
				};			
                var ms = {
                    cmd: 'appxMongoToEngine',
					args: args,
                    handler: "appxreceivefilehandler",
                    type: "LOCALOS-OPENFILE",
                    fileName: mFileName,
                    mongoFileName: mongoFileName,
                    data: null
                };
                ws.send(JSON.stringify(ms));
				// get the finish date
				var finishdate = new Date();
				// get total seconds between the times
				var delta = Math.abs(finishdate - startdate) / 1000;
				// calculate (and subtract) whole days
				var days = Math.floor(delta / 86400);
				delta -= days * 86400;
				// calculate (and subtract) whole hours
				var hours = Math.floor(delta / 3600) % 24;
				delta -= hours * 3600;
				// calculate (and subtract) whole minutes
				var minutes = Math.floor(delta / 60) % 60;
				delta -= minutes * 60;
				// what's left is seconds
				var seconds = delta % 60;  // in theory the modulus is not required				
				logit("Command: Open File (finished - elapsed time: " + hours.toLocaleString('en-US', { minimumIntegerDigits: 2, useGrouping: false })
																	  + ":" + minutes.toLocaleString('en-US', { minimumIntegerDigits: 2, useGrouping: false })
																	  + ":" + seconds.toLocaleString('en-US', { minimumIntegerDigits: 2, maximumFractionDigits: 0, useGrouping: false })
																	  + ")");
            }
        });
        
    } catch (e) {
        logit("openfile: **ERROR** Catch(ex) = " + JSON.stringify(e));
        console.log(e);
        console.log(e.stack);
    }
}

/**
 * cmdFileDialogNwFn - implementation of the 'file-dialog-nw' command.
 * 
 * This command will present an open file dialog and return the pathname.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdFileDialogNwFn(ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);
        return;
    }

    logit("Command: Open File Dialog (started)");

    //check if a window has already been opened
    if (!global.filedialog) {

		var startdate = new Date();

        global.filedialog = {
            data: ms.data,
            filename: ""
        };

        var h = 1,
            w = 1;

        // Create a new window and get it
        var new_win = nw.Window.open('file-dialog.htm', {
            "frame": false,
            "height": h,
            "position": "mouse",
            "show": true,
            "show_in_taskbar": false,
            "always_on_top": true,
            "focus": true,
            "width": w
        }, function (win) {
            // Release the 'win' object here after the new window is closed.
            win.on('closed', function () {
                var ms = {
                    data: [global.filedialog.filename],
                    hasdata: "yes",
                    haserrors: "no",
                    type: "LOCALOS-FILE-DIALOG"
                };
                ws.send(JSON.stringify(ms));

				// get the finish date
				var finishdate = new Date();
				// get total seconds between the times
				var delta = Math.abs(finishdate - startdate) / 1000;
				// calculate (and subtract) whole days
				var days = Math.floor(delta / 86400);
				delta -= days * 86400;
				// calculate (and subtract) whole hours
				var hours = Math.floor(delta / 3600) % 24;
				delta -= hours * 3600;
				// calculate (and subtract) whole minutes
				var minutes = Math.floor(delta / 60) % 60;
				delta -= minutes * 60;
				// what's left is seconds
				var seconds = delta % 60;  // in theory the modulus is not required		
				logit("Command: Open File Dialog - User Selected Filename: " + (global.filedialog.filename != "" ? global.filedialog.filename : "<None Selected>")); 
				logit("Command: Open File Dialog (finished - elapsed time: " + hours.toLocaleString('en-US', { minimumIntegerDigits: 2, useGrouping: false })
																			 + ":" + minutes.toLocaleString('en-US', { minimumIntegerDigits: 2, useGrouping: false })
																			 + ":" + seconds.toLocaleString('en-US', { minimumIntegerDigits: 2, maximumFractionDigits: 0, useGrouping: false })
																			 + ")");
																	  
                global.filedialog = null;
                win = null;
            });
        });
    }
}

/**
 * cmdDndFn - implementation of the 'dnd' command.
 * 
 * This command will process a drag and drop request.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdDndFn( ms, ws, appx_session, isAuthorized) {

    if( ! isAuthorized ) {
        console.log("*** Not Authorized!");
        console.dir(ms);
        return;
    }

    logit("Command: Drag n' Drop Filename (started)");

    //check if a window has already been opened
    if (!global.dnd) {
		
        global.dnd = {
            data: ms.data,
            entries: [],
        };

        //process.execPath is the location of our running nw executable
        global.dir = path.dirname(process.execPath);
        global.dnd.log = {
            line: 0,
            file: path.join(global.dir, 'appxloconwdnd.log')
        };

        function dndLog(str) {
            try {
                var gdl = global.dnd.log;
                gdl.line++;
                str = "[" + gdl.line + "]\r\n" + str + "\r\n";
                if (gdl.line == 1)
                    fs.writeFileSync(gdl.file, str);
                else
                    fs.appendFileSync(gdl.file, str);
            } catch (ex) {
                alert('dndLog: ' + ex);
            }
        }

        function dndSend() {
            if (global.dnd.entries.length > 0) {
                var ms = {
                    data: global.dnd.entries,
                    hasdata: "yes",
                    haserrors: "no",
                    type: "LOCALOS-DND"
                };
                dndLog('JSON: ' + JSON.stringify(ms));
                ws.send(JSON.stringify(ms));
            }
            global.dnd = null;
        }

        var file = path.join(global.dir, 'AppxTools.exe');
        dndLog('file: ' + file);
        if (process.platform.indexOf('win') != -1 && fs.existsSync(file)) {
            //run windows .net dnd to support outlook
            var args = [global.dnd.data.wDnD];
            var opts = {
                maxBuffer: 200 * 1024 * 10 * 15
            };
			
            require('child_process').execFile(file, args, opts, function (error, stdout, stderr) {
				var startdate = new Date();
                if (error) {
                    dndLog('error: ' + error);
                    alert('.NET DnD error: ' + error);
                } else {
                    //parse all the lines from standard output
                    dndLog("stdout:\r\n" + stdout);
					
					// If available, get the count of Drag and Drop filenames
					var fileCount = 0;
					var fileCountIdx = 0;
					if ((fileCountIdx = stdout.search(/File Count: /i)) != -1) {
						var numberStr = stdout.slice(fileCountIdx);
						var numberIdx = numberStr.search(/\d+[\r\n]+/i);
						fileCount = (numberStr.slice(numberIdx)).replace(/[\r\n]+/gm, '');
						stdout = stdout.replace(/File Count: \d+[\r\n]+/, '');
					}

					logit("Drag n' Drop - fileCount: " + fileCount);		
					
                    var lines = stdout.split("\r\n");

					// When the count of files that were dropped matches or exceeds the trigger point set up and display the drag and drop informational popup window
					logit("Drag n' Drop - showInfoPopup: " + localStorage.getItem("showInfoPopup"));
					if ((fileCount >= fileCountTrigger) && (localStorage.getItem("showInfoPopup") == "true")) {
						logit("Drag n' Drop - Filecount >= fileCountTrigger: ("  + fileCount + " >= " + fileCountTrigger + ")" + " Will invoke the Drag and Drop Informational popup window");					
						
						var dndinfofilename = '';
						try {
							// Formulate a filename based upon the authorization token
							dndinfofilename = "dndinfo-" + appx_session.authToken + ".html";

							// Read the dndinfo.html file, then modify its contents with the file count of the drang and drop operation
							var contentsString = (fs.readFileSync('dndinfo.html', "utf-8").toString('utf8')).replace("xxx,xxx,xxx,xxx", fileCount.toLocaleString());

							// Save the modifed contents of the dndinfo.html file for use as the dnd informational popup 
							fs.writeFileSync(dndinfofilename, contentsString);
							
						} catch (error) {
							dndinfofilename = "dndinfo.html";
							logit("Drag n' Drop - synchronous file operations: FAILED - will use filename: " + dndinfofilename);					
						}
						
						var h = 235,
							w = 555;
						var new_win = nw.Window.open(dndinfofilename, {
							"frame": false,
							"height": h,
							"position": "center",
							always_on_top: true,
							"show": true,
							"show_in_taskbar": false,
							"width": w
						}, function (win) {
							// Release the 'win' object here after the new window is closed.
							win.on('closed', function () { win = null; fs.unlinkSync(dndinfofilename); });
								
							setTimeout( function() { win.close(); fs.unlinkSync(dndinfofilename); }, ((fileCount * timeFactor) * second) );								
						});
					}
					
					async function processDndFileList(global, count, lines) {
						var entry = null;
						var gdd = global.dnd.data;
						let fileCount = 1;
						
						if (count >= fileCountTrigger) {
							await sleep(250);
						}
						
						for (var i = 0; i < lines.length; i++) {
							//entries separated by blank line
							if (i == 0 || lines[i - 1] == '' || i + 1 == lines.length) {
								if (i != 0) global.dnd.entries.push(entry);
								entry = {
									'row': gdd.wPosY,
									'col': gdd.wPosX,
									'path': '',
									'name': '',
									'ext': '',
									'mtype': '',
									'size': 0,
									'props': [],
									'parentType': gdd.wPrnt
								};
							}
							//properties separated by semicolumn
							var col = lines[i].indexOf(':');
							if (col > 0) {
								var label = lines[i].substr(0, col);
								if (label == 'type') label = 'mtype';
								
								var value = lines[i].substr(col + 2);
								
								if (label == 'path') { logit("Drag n' Drop - File" + "(" + fileCount +"): " + value); fileCount++; }
								
								if (entry.hasOwnProperty(label)) {
									entry[label] = value;
								} else if (value != '') { //otherwise a property
									entry.props.push({
										'name': label,
										'value': value
									});
								}
							}
						}
						
						dndSend();
					
						// get the finish date
						var finishdate = new Date();
						// get total seconds between the times
						var delta = Math.abs(finishdate - startdate) / 1000;
						// calculate (and subtract) whole days
						var days = Math.floor(delta / 86400);
						delta -= days * 86400;
						// calculate (and subtract) whole hours
						var hours = Math.floor(delta / 3600) % 24;
						delta -= hours * 3600;
						// calculate (and subtract) whole minutes
						var minutes = Math.floor(delta / 60) % 60;
						delta -= minutes * 60;
						// what's left is seconds
						var seconds = delta % 60;  // in theory the modulus is not required		
						logit("Command: Drag n' Drop Filename (finished - elapsed time: " + hours.toLocaleString('en-US', { minimumIntegerDigits: 2, useGrouping: false })
																						  + ":" + minutes.toLocaleString('en-US', { minimumIntegerDigits: 2, useGrouping: false })
																						  + ":" + seconds.toLocaleString('en-US', { minimumIntegerDigits: 2, maximumFractionDigits: 0, useGrouping: false })
																						  + ")");
					}
					processDndFileList(global, fileCount, lines);																  
                }
            });

        } else { //not windows, don't use .net solution

            var h = 110,
                w = 110;
            var new_win = nw.Window.open('dnd.htm', {
                "frame": false,
                "height": h,
                "position": "mouse",
                "show": true,
                "show_in_taskbar": false,
                "width": w
            }, function (win) {
                // Release the 'win' object here after the new window is closed.
                win.on('closed', function () {
                    dndSend();
                    win = null;
                });
            });
        }
    }
}

/**
 * cmdAuthFn - implementation of the 'auth' command.
 * 
 * This command will present an access code and allow the user to accept or deny access.
 * 
 * @param {*} ms - message transaction
 * @param {*} ws - websocket handle
 * @param {*} appx_session - Session info
 * @param {*} isAuthorized - Is this command authenticated
 */

function cmdAuthFn( ms, ws, appx_session, isAuthorized) {
    global.appName = ms.data.appName;
    global.accessCode = ms.data.accessCode;
    var h = 350,
        w = 600;
    var new_win = nw.Window.open('auth.htm', {
        "frame": true, //false,
        "height": h,
        "title": "Access Request",
        "position": "center",
        "show": true,
        "show_in_taskbar": true, //false,
        "width": w
    }, function (win) {
        // Release the 'win' object here after the new window is closed.
        win.on('closed', function () {
            var ms = {
                data: {},
                hasdata: "yes",
                haserrors: "no",
                type: "LOCALOS-AUTH"
            };
            if (global.authDialogState === "allow") {
                let authToken = generateAuthToken();
                ms.data.authStatus = "allow";
                ms.data.authToken = authToken;
                persistStorage.authTokens[authToken] = "valid";
                savePersistStorage();
            }
            ws.send(JSON.stringify(ms));
            win = null;
        });
    });
}

function sleep(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}

function hton16(i) {
    return [
        0xff & (i >> 8),
        0xff & (i >> 0)
    ];
}

function hton32(i) {
    return [
        0xff & (i >> 24),
        0xff & (i >> 16),
        0xff & (i >> 8),
        0xff & (i >> 0)
    ];
}

function toUTF8Array(str) {
    var utf8 = [];
    for (var i = 0; i < str.length; i++) {
        var charcode = str.charCodeAt(i);
        if (charcode < 0x80) utf8.push(charcode);
        else if (charcode < 0x800) {
            utf8.push(0xc0 | (charcode >> 6),
                0x80 | (charcode & 0x3f));
        } else if (charcode < 0xd800 || charcode >= 0xe000) {
            utf8.push(0xe0 | (charcode >> 12),
                0x80 | ((charcode >> 6) & 0x3f),
                0x80 | (charcode & 0x3f));
        }
        // surrogate pair
        else {
            i++;
            // UTF-16 encodes 0x10000-0x10FFFF by
            // subtracting 0x10000 and splitting the
            // 20 bits of 0x0-0xFFFFF into two halves
            charcode = 0x10000 + (((charcode & 0x3ff) << 10) | (str.charCodeAt(i) & 0x3ff))
            utf8.push(0xf0 | (charcode >> 18),
                0x80 | ((charcode >> 12) & 0x3f),
                0x80 | ((charcode >> 6) & 0x3f),
                0x80 | (charcode & 0x3f));
        }
    }
    return utf8;
}

function cmdLocalOsInitFn(ms, ws, appx_session) {
    // This appxinit message provides the opportunity to push down any assets needed on the client

    if (!persistStorage.authTokens) {
        persistStorage.authTokens = {};
    }

    if (isAuthorized(ms)) {
        appx_session.authToken = ms.authToken;
    } else {
        appx_session.authToken = undefined;
    }

    if (ms.data && ms.data.languageId)
        global.lang = ms.data.languageId;

    /*We require at least node webkit version 0.12.3. If version does
    **not meet minimum version then we exit so user will be prompted to
    **download newer version.*/
    var nwVersion = process.versions['node-webkit'].split(".");
    if (!(nwVersion[0] > 0 || nwVersion[1] >= 12)) {
        var h = 250,
            w = 400;
        var new_win = nw.Window.open('upgrade.html', {
            "frame": false,
            "height": h,
            "position": "mouse",
            "show": true,
            "show_in_taskbar": false,
            "width": w
        });
    }

    //send user enviroment data
    var pe = process.env;
    pe.currentworkingdirectory = process.cwd();
    pe.localConnectorVersionStr = localConnectorVersionStr;
    pe.localConnectorVersionNum = localConnectorVersionNum;

    if (appx_session.authToken && persistStorage.authTokens[appx_session.authToken] === "valid") {
        pe.authTokenValid = true;
        pe.authTokenValue = appx_session.authToken;
    } else {
        delete pe.authTokenValid;
        delete pe.authTokenValue;
    }

    ms.data = pe;
    ms.hasdata = "yes";
    ms.haserror = "no";
    ms.type = "LOCALOS-ENVIRONMENT";
    ws.send(JSON.stringify(ms));
}

function isAuthorized( ms ) {
    if (ms && ms.authToken && persistStorage.authTokens[ms.authToken] === "valid") {
        return true;
    }

    return false;
}

function generateAuthToken() {
    var dt = new Date().getTime();
    var uuid = 'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = (dt + Math.random() * 16) % 16 | 0;
        dt = Math.floor(dt / 16);
        return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
    });
    return uuid;
}

function savePersistStorage() {
    localStorage.persistStorage = JSON.stringify(persistStorage);
}

function getPersistStorage() {
    if (localStorage.persistStorage) {
        persistStorage = JSON.parse(localStorage.persistStorage);
    } else {
        persistStorage = {};
    }
}

/* set the certificate authority for local connector*/
function cmdGetCertificateFn( ms, ws, appx_session, isAuthorized){
    logit("Local connector cert auth received");
    if(ms.data){
        appx_session.ca = Buffer.from(ms.data.data).toString();
        logit(appx_session.ca);
    }
}

console.log("Server Running...");