/*
 * This is the main entry point to the Data Services API.
 */

global.dirname = __dirname;
global.dataServicesVersionStr = "1.0.0.24082713";
global.dataServicesVersionNum = 10000.24082713;

var express = require('express');
var config = require('config');
var bodyParser = require('body-parser');
var appxConn = require('./lib/appx');
var fs = require('fs');
var https = require('https');
var checks = require('./lib/checkconfigs');
checks.checkappconfig();

// Set up the express app and config object
var app = express();
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: true }));

// Security considerations
app.disable('x-powered-by');

// Setup the APPX Connection
global.appx = new appxConn();

// Register our express middleware
app.use(function (req, res, next) {
    debugConfig.log(debugConfig.STAT, req.method + ': ' + req.path);
    next();
});

// Intercept res.json() and set the HTTP status code if it exists
app.use(function (req, res, next) {
    res.jsonfinal = res.json;

    res.json = function (data) {
        if (data.RESPONSE) {
            res.statusCode = data.RESPONSE;
        }
        res.jsonfinal(data);
    };

    // Set the API Client's IP, getting it from a custom header if specified
    if (appConfig.hasOwnProperty('customIPHeader') && appConfig.customIPHeader != '') {
        req.headers['fws-apiclient-ip'] = req.headers[appConfig.customIPHeader];
    } else {
        req.headers['fws-apiclient-ip'] = req.connection.remoteAddress;
    }

    next();
});

// Import the routes.
app.use('/', require('./routes'));

// Start with SSL if it's enabled in the config, or without if it isn't
if (appConfig.enablessl == true) {

	if (appConfig.sslPfxFile === "") {
		var secureServer = https.createServer({
			key: fs.readFileSync(appConfig.privatekeypath),
			cert: fs.readFileSync(appConfig.certificatepath)
		}, app)
			.listen(appConfig.port, function () {
				debugConfig.log(debugConfig.STAT, 'Secure (.crt) Data Services API listening on port ' + appConfig.port + '...');
			});
	} else {
		var secureServer = https.createServer({
			pfx: fs.readFileSync(appConfig.sslPfxFile),
			passphrase: appConfig.sslPfxPassphrase
		}, app)
			.listen(appConfig.port, function () {
				debugConfig.log(debugConfig.STAT, 'Secure (.pfx) Data Services API listening on port ' + appConfig.port + '...');
			});
	}
}
else {
    // Set up the express app and config object with SSL DISABLED
    // Start the server.
    app.listen(appConfig.port, function () {
        debugConfig.log(debugConfig.STAT, 'Data Services API listening on port ' + appConfig.port + '...');
    });
}
